<?php
error_reporting(E_ERROR | E_PARSE);
@set_time_limit(0);
@ignore_user_abort(true);
require_once (__DIR__.'/include/crest.php');
require_once (__DIR__.'/phpexcel-1.9/Classes/PHPExcel.php');
// require_once (__DIR__.'/phpexcel-php8/Classes/PHPExcel.php');

if($_REQUEST['form_submit'] == 'true' && $_REQUEST['deal_id'] !== ''){

	$deal_id = $_REQUEST['deal_id'];

	

	$deal = CRest::call("crm.deal.get", array(

		"id" => $deal_id,

	));

	$deal_data = $deal['result'];

	$contact_id = $deal_data['CONTACT_ID'];

	$company_id = $deal_data['COMPANY_ID'];

	sleep(2);

	$newQuote = CRest::call("crm.quote.add", array(

		"fields" => [

			"TITLE" => $deal_data['TITLE'], 

			"STATUS_ID" => "DRAFT",

			"OPENED" => "Y", 

			"ASSIGNED_BY_ID" => $deal_data['ASSIGNED_BY_ID'],

			"CREATED_BY_ID" => $deal_data['ASSIGNED_BY_ID'],

			"CURRENCY_ID" => "USD", 

			"OPPORTUNITY" => $deal_data['OPPORTUNITY'],

			"CONTACT_ID" => $contact_id,

			"COMPANY_ID" => $company_id,

			"DEAL_ID" => $deal_id,

		]

	));

	$quote_id = $newQuote['result'];

	sleep(2);

	$quote = CRest::call("crm.item.get", array(

		"entityTypeId" => 7,

		"id" => $quote_id,

	));

	$quote_data = $quote['result']['item'];



	$products = CRest::call("crm.item.productrow.list", array(

		"order" => [],

		"filter" => [

			"=ownerType" => "D",

			"=ownerId" => $deal_id

		],

		"start" => "-1",

	));
	if($products['result'] && $products['result']['productRows']){
		$products_list = $products['result']['productRows'];

		$quote_products = [];
		////////////////////////////////////////////////////
		$commands = [];
		$get_products_batch = [];
		$arProducts = [];

		$commands_per_page = 50;
		foreach($products_list as &$product){
			$commands[$product['productId']] = 'catalog.product.get?'.http_build_query(["id" => $product['productId']]);
		}
		if(count($commands) > $commands_per_page){
			$cpp = 0;
			$temp_commands = [];
			$temp_res = [];

			foreach($commands as $k => $command){
				++$cpp;
				$temp_commands[$k] = $command;
				if($cpp == $commands_per_page){
					$temp_res = CRest::call('batch', [
						'halt' => 0,
						'cmd' => $temp_commands
					])['result']['result'];

					$get_products_batch = array_merge($get_products_batch, $temp_res);
					$cpp = 0;
					$temp_commands = [];
				}
			}
		}else{
			$get_products_batch = CRest::call('batch', [
				'halt' => 0,
				'cmd' => $commands
			])['result']['result'];
		}
		foreach($get_products_batch as $temp_product){
			$arProducts[$temp_product['product']['id']] = $temp_product['product'];
		}
		////////////////////////////////////////////////////
		foreach($products_list as &$product){
			/*
			$resGoodsList = CRest::call(
				'catalog.product.get',
				[
					"id" => $product['productId'],
				]
			);
			*/

			if($arProducts[$product['productId']]){
				$product['CATALOG'] = $arProducts[$product['productId']];
			}

			$curQuoteProduct = [];
			$curQuoteProduct["ownerId"] = $quote_id;
			$curQuoteProduct["ownerType"] = "SI";
			$curQuoteProduct["productId"] = $product['productId'];
			$curQuoteProduct["productName"] = $product['productName'];
			$curQuoteProduct["price"] = $product['price'];
			$curQuoteProduct["quantity"] = $product['quantity'];

			$quote_products[] = $curQuoteProduct;
		}



		/* ADD PRODUCTS TO QUOTE (JUST IN CASE)*/

		sleep(1);

		$resAddQuoteGoodsList = CRest::call(

			'crm.item.productrow.set',

			[

				"ownerType" => "Q",

				"ownerId" => $quote_id,

				"productRows" => $quote_products

			]

		);

		

		/* END ** ADD PRODUCTS TO QUOTE (JUST IN CASE) ** END */

		

		$contact = CRest::call("crm.contact.get", array(

			"id" => $contact_id

		));
		if(isset($contact['result'])){
			$contact_data = $contact['result'];
		}else{
			$contact_data = [];
		}

		sleep(1);

		$company = CRest::call("crm.company.get", array(

			"id" => $company_id

		));
		$company_name = '';
		if(isset($company['result']) && $company['result']){
			$company_data = $company['result'];
			$company_name = $company_data['TITLE'];
		}else{
			$company_data = [];
		}


		sleep(1);
		if($company_id && $company_id !== ''){
			$address = CRest::call("crm.address.list", array(
	
				"order" => [],
	
				"filter" => [
	
					"ENTITY_TYPE_ID" => 4,
	
					"ENTITY_ID" => $company_id
	
				],
	
				'select' => ["ADDRESS_1", "ADDRESS_2", "CITY", "POSTAL_CODE", "REGION", "PROVINCE", "COUNTRY", "COUNTRY_CODE"]
	
			));
		}
		if(isset($address['result']) && $address['result'] && $address['result'][0]){
			$address_data = $address['result'][0];
		}else{
			$address_data = [];
		}

		$wsrecord = [];

		$wsrecord['createdtime'] = $deal_data['DATE_CREATE'];



		$wsrecord['company']['organizationname'] = "Applied Physics, Inc.";

		$wsrecord['company']['address'] = "2812 N 34th St.

	";

		$wsrecord['company']['city'] = "Tampa";

		$wsrecord['company']['state'] = "FL";

		$wsrecord['company']['code'] = "33605";

		$wsrecord['company']['country'] = "USA";

		$wsrecord['contact_id'] = $contact_id;

		$wsrecord['quote_no'] = $quote_data['quoteNumber'];

		

		$wsrecord['contact']['firstname'] = $contact_data['NAME'];

		$wsrecord['contact']['lastname'] = $contact_data['LAST_NAME'];

		$wsrecord['account']['accountname'] = $company_name;



		$contact_full_name = $contact_data['NAME'].' '.$contact_data['LAST_NAME'];

		if(isset($contact_data) && $contact_data['PHONE'] && count($contact_data['PHONE'])>0){

			$contact_phone = $contact_data['PHONE'][0]['VALUE'];

		}

		if(isset($contact_data) && $contact_data['EMAIL'] && count($contact_data['EMAIL'])>0){

			$contact_email = $contact_data['EMAIL'][0]['VALUE'];

		}

		if(isset($company_data) && $company_data['PHONE'] && count($company_data['PHONE'])>0){

			$wsrecord['account']['phone'] = $company_data['PHONE'][0]['VALUE'];

			$company_phone = $company_data['PHONE'][0]['VALUE'];

		}else{
			$wsrecord['account']['phone'] = '';
			$company_phone = '';
		}

		if(isset($company_data) && $company_data['EMAIL'] && count($company_data['EMAIL'])>0){

			$wsrecord['account']['email'] = $company_data['EMAIL'][0]['VALUE'];

			$company_email = $company_data['EMAIL'][0]['VALUE'];

		}else{
			$wsrecord['account']['email'] = '';
			$company_email = '';
		}

		if($address_data && is_array($address_data)){

			$wsrecord['bill_street'] = $address_data['ADDRESS_1'] ? $address_data['ADDRESS_1'] : '';

			$wsrecord['bill_street_2'] = $address_data['ADDRESS_2'] ? $address_data['ADDRESS_2'] : '';

			$wsrecord['bill_city'] = $address_data['CITY'] ? $address_data['CITY'] : '';

			$wsrecord['bill_state'] = $address_data['PROVINCE'] ? $address_data['PROVINCE'] : '';

			$wsrecord['bill_code'] = $address_data['POSTAL_CODE'] ? $address_data['POSTAL_CODE'] : '';

			$wsrecord['bill_country'] = $address_data['COUNTRY'] ? $address_data['COUNTRY'] : '';

			

			$contact_state = $address_data['PROVINCE'] ? $address_data['PROVINCE'] : '';

			$contact_country = $address_data['COUNTRY'] ? $address_data['COUNTRY'] : '';

		}else{

			$wsrecord['bill_street'] = '';

			$wsrecord['bill_city'] = '';

			$wsrecord['bill_state'] = '';

			$wsrecord['bill_code'] = '';

			$wsrecord['bill_country'] = '';
			$contact_state = '';
			$contact_country = '';
		}



		/* EXCEL***********************************/

			$objPHPExcel = new PHPExcel();

			$objPHPExcel->getSecurity()->setLockWindows(false);

			$objPHPExcel->getSecurity()->setLockStructure(false);

			$objPHPExcel->getSecurity()->setWorkbookPassword("");

			$objPHPExcel->getDefaultStyle()->getFont()

				->setName('Arial Narrow')

				->setSize(8)

				->setBold(true);

			// Set document properties

			$objPHPExcel->getProperties()->setCreator("Maarten Balliauw")

											->setLastModifiedBy("Maarten Balliauw")

											->setTitle("Office 2007 XLSX Test Document")

											->setSubject("Office 2007 XLSX Test Document")

											->setDescription("Test document for Office 2007 XLSX, generated using PHP classes.")

											->setKeywords("office 2007 openxml php")

											->setCategory("Test result file");





			// Create a first sheet, representing sales data

			$styleArray = array(

			'font'  => array(

					'bold'  => false,

					'size'  => 7,

					'name'  => 'Times New Roman'

				),

				'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER)

			);

			$styleB7Array = array(

			'font'  => array(

					'bold'  => true,

					'size'  => 7,

					'name'  => 'Times New Roman'

				),

				'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER)

			);  

			$styleC3C4Array = array(

			'font'  => array(

					'bold'  => true,

					'size'  => 10,

					'name'  => 'Times New Roman'

				),

				'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT)

			);  	

			$objPHPExcel->setActiveSheetIndex(0);

			$objPHPExcel->getActiveSheet()->setCellValue('D2', $wsrecord['company']['organizationname']);

			$objPHPExcel->getActiveSheet()->setCellValue('D3', $wsrecord['company']['address']);

			$objPHPExcel->getActiveSheet()->setCellValue('D4', $wsrecord['company']['city'].', '.$wsrecord['company']['state'].' '.$wsrecord['company']['code'].' '.$wsrecord['company']['country']);

			$objPHPExcel->getActiveSheet()->getStyle('B3')->applyFromArray(array('alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT)));

			$objPHPExcel->getActiveSheet()->getStyle('D3')->applyFromArray($styleC3C4Array);

			$objPHPExcel->getActiveSheet()->getStyle('D4')->applyFromArray($styleC3C4Array);     

			$objPHPExcel->getActiveSheet()->getRowDimension('2')->setRowHeight(30);



			$objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(2);



			$objPHPExcel->getActiveSheet()->setCellValue('G2', 'Nano Particle Technology');

			$objPHPExcel->getActiveSheet()->setCellValue('G3', 'Phone');

			$objPHPExcel->getActiveSheet()->setCellValue('G4', 'Email');

			$objPHPExcel->getActiveSheet()->setCellValue('G5', 'WEB');

			$objPHPExcel->getActiveSheet()->getStyle('G3:G5')->applyFromArray(

				array(

					'font'  => array(

						'bold'  => true,

						'size'  => 10,

						'name'  => 'Times New Roman'

					),

					'alignment' => array(

						'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT

					)

				)

			);

			$objPHPExcel->getActiveSheet()->setCellValue('H3', '(719) 428-4042');

			$objPHPExcel->getActiveSheet()->setCellValue('H4', 'Sales@AppliedPhysicsUSA.com');

			$objPHPExcel->getActiveSheet()->setCellValue('H5', 'www.AppliedPhysicsUSA.com');

					

			$objPHPExcel->getActiveSheet()->getStyle('A3:H5')->getFont()->setName('Times New Roman');

			$objPHPExcel->getActiveSheet()->getStyle('A3:H5')->getFont()->setSize(8);      

					

			$objPHPExcel->getActiveSheet()->setCellValue('B7', 'This quote supersedes any previous quote.');



			$objPHPExcel->getActiveSheet()->getStyle('B7')->applyFromArray($styleB7Array);



			$objPHPExcel->getActiveSheet()->setCellValue('E8', 'Quote #:');

			$objPHPExcel->getActiveSheet()->getStyle('E8')->applyFromArray(array('alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT)));

			$objPHPExcel->getActiveSheet()->setCellValue('F8', $wsrecord['quote_no']);





			$objPHPExcel->getActiveSheet()->setCellValue('B9', 'Remit to');

			$objPHPExcel->getActiveSheet()->setCellValue('B15', 'Tel');

			$objPHPExcel->getActiveSheet()->setCellValue('B16', 'eMail');

			$name = $wsrecord['contact']['firstname']." ".$wsrecord['contact']['lastname'];





			$objPHPExcel->getActiveSheet()->setCellValue('D9',  $wsrecord['account']['accountname']);

			$objPHPExcel->getActiveSheet()->setCellValue('D10', $name);

			$objPHPExcel->getActiveSheet()->setCellValue('D11', $wsrecord['bill_street']);

			$objPHPExcel->getActiveSheet()->setCellValue('D12', $wsrecord['bill_street_2']);

			$objPHPExcel->getActiveSheet()->setCellValue('D13', $wsrecord['bill_city'].', '.$wsrecord['bill_state'].' '.$wsrecord['bill_code']);

			$objPHPExcel->getActiveSheet()->setCellValue('D14', $wsrecord['bill_country']);

			$objPHPExcel->getActiveSheet()->setCellValue('D15', $wsrecord['account']['phone']);





			$objPHPExcel->getActiveSheet()->getStyle('D15')->applyFromArray(array('alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT)));

			$objPHPExcel->getActiveSheet()->setCellValue('D16', $wsrecord['account']['email']);



			$objPHPExcel->getActiveSheet()->setCellValue('E9', "=E8");

			$objPHPExcel->getActiveSheet()->setCellValue('E10', 'Customer PO #:');

			$objPHPExcel->getActiveSheet()->setCellValue('E11', 'Date:');

			$objPHPExcel->getActiveSheet()->setCellValue('E12', 'Carrier:');

			$objPHPExcel->getActiveSheet()->setCellValue('E13', 'Payment Terms:');

			$objPHPExcel->getActiveSheet()->setCellValue('E14', 'Customs/Duty/Tax:');

			$objPHPExcel->getActiveSheet()->setCellValue('E15', 'US State Taxes:');

			$objPHPExcel->getActiveSheet()->setCellValue('E16', 'Warranty');



			$configs = "Fed Ex, UPS, Postal, Freight, Customer Shipping Account, other";



			$objValidation = $objPHPExcel->getActiveSheet()->getCell('F12')->getDataValidation();

			$objValidation->setType( PHPExcel_Cell_DataValidation::TYPE_LIST );

			$objValidation->setErrorStyle( PHPExcel_Cell_DataValidation::STYLE_INFORMATION );

			$objValidation->setAllowBlank(false);

			$objValidation->setShowInputMessage(true);

			$objValidation->setShowErrorMessage(true);

			$objValidation->setShowDropDown(true);

			$objValidation->setErrorTitle('Input error');

			$objValidation->setError('Value is not in list.');

			$objValidation->setPromptTitle('Pick from list');

			$objValidation->setPrompt('Please pick a value from the drop-down list.');

			$objValidation->setFormula1('"'.$configs.'"');





			$objPHPExcel->getActiveSheet()->setCellValue('F9', "=F8");

			$objPHPExcel->getActiveSheet()->setCellValue('F10', '');

			$objPHPExcel->getActiveSheet()->setCellValue('F11', date("d-M-Y",strtotime($wsrecord['createdtime'])));

			$objPHPExcel->getActiveSheet()->setCellValue('F13', 'Wire w/ PO');

			$objPHPExcel->getActiveSheet()->setCellValue('F14', 'Int. Customer Pays');

			$objPHPExcel->getActiveSheet()->setCellValue('F15', 'USA Customer Pays');

			$objPHPExcel->getActiveSheet()->setCellValue('F16', '1 Year from Ship');



			$objPHPExcel->getActiveSheet()->setCellValue('G9', 'Ship');

			$objPHPExcel->getActiveSheet()->setCellValue('G10', 'To');

			$objPHPExcel->getActiveSheet()->setCellValue('G15', 'Tel');

			$objPHPExcel->getActiveSheet()->setCellValue('G16', 'eMail');



			$objPHPExcel->getActiveSheet()->setCellValue('H9',  "=D9");

			$objPHPExcel->getActiveSheet()->setCellValue('H10', "=D10");

			$objPHPExcel->getActiveSheet()->setCellValue('H11', "=D11");

			$objPHPExcel->getActiveSheet()->setCellValue('H12', "=D12");

			$objPHPExcel->getActiveSheet()->setCellValue('H13', "=D13");

			$objPHPExcel->getActiveSheet()->setCellValue('H15', "=D15");

			$objPHPExcel->getActiveSheet()->getStyle('H15')->applyFromArray(array('alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT)));

			$objPHPExcel->getActiveSheet()->setCellValue('H16', "=D16");



			$objPHPExcel->getActiveSheet()->setCellValue('B17', 'Item');

			$objPHPExcel->getActiveSheet()->setCellValue('D17', 'Description');

			$objPHPExcel->getActiveSheet()->setCellValue('E17', 'Part #');

			$objPHPExcel->getActiveSheet()->setCellValue('F17', 'Price');

			$objPHPExcel->getActiveSheet()->setCellValue('G17', 'QTY');

			$objPHPExcel->getActiveSheet()->setCellValue('H17', 'Total');



			$styleborders = array(

				'font'=> array('bold'=>false),

				'borders' => array(

					'top'		=> array('style' => PHPExcel_Style_Border::BORDER_THIN),

					'right'		=> array('style' => PHPExcel_Style_Border::BORDER_THIN),

					'left'		=> array('style' => PHPExcel_Style_Border::BORDER_THIN),

					'bottom'	=> array('style' => PHPExcel_Style_Border::BORDER_THIN)

				)					

			);

			$stylebordersG = array(

				'font'=> array('bold'=>false),

				'borders' => array(

					'top'		=> array('style' => PHPExcel_Style_Border::BORDER_THIN),

					'right'		=> array('style' => PHPExcel_Style_Border::BORDER_MEDIUM),

					'left'		=> array('style' => PHPExcel_Style_Border::BORDER_THIN),

					'bottom'	=> array('style' => PHPExcel_Style_Border::BORDER_THIN)

				),

				'alignment' => array(

					'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,

				)	    

			);  

			$stylebordersB = array(

				'font'=> array('bold'=>true),

				'borders' => array(

					'top'		=> array('style' => PHPExcel_Style_Border::BORDER_THIN),

					'right'		=> array('style' => PHPExcel_Style_Border::BORDER_THIN),

					'left'		=> array('style' => PHPExcel_Style_Border::BORDER_THIN),

					'bottom'	=> array('style' => PHPExcel_Style_Border::BORDER_THIN)

				),

				'alignment' => array(

					'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,

				)	    

			);           

			$fillColor = array('fill' 	=> array('type'=> PHPExcel_Style_Fill::FILL_SOLID,'color'=> array('rgb' => 'EDEDED')));

			$fillColorb = array('fill' 	=> array('type'=> PHPExcel_Style_Fill::FILL_SOLID,'color'=> array('rgb' => 'DEEBED')));

			$fillColoryello = array('fill' 	=> array('type'=> PHPExcel_Style_Fill::FILL_SOLID,'color'=> array('rgb' => 'FFFF00')));

			$fillColorToC = array(

				'font'    => array(

					'bold'      => true

				),

				'fill' 	=> array(

					'type'		=> PHPExcel_Style_Fill::FILL_SOLID,

					'color'		=> array('rgb' => 'DEEBED')

				),

				'alignment' => array(

					'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,

				)				

			);

			$fillColorToF = array(

				'font'    => array(

					'bold'  => true,

					'size'  => 8,

					'name'  => 'Arial Narrow'

				),

				'fill' 	=> array(

					'type'		=> PHPExcel_Style_Fill::FILL_SOLID,

					'color'		=> array('rgb' => 'EDEDED')

				),

				'alignment' => array(

					'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,

				)				

			);    

					

			$baseRow = 19;



			foreach($products_list as $k => &$product){

				$row = $baseRow + $k;

				$product_code = '';

				$product_code = $product['CATALOG']['property98']['value'] ? $product['CATALOG']['property98']['value'] : '';

				$objPHPExcel->getActiveSheet()->insertNewRowBefore($row,1);

				$objPHPExcel->getActiveSheet()->setCellValue('B'.$row, $k+1);

				$objPHPExcel->getActiveSheet()->setCellValue('D'.$row, $product['productName']);

				$objPHPExcel->getActiveSheet()->setCellValue('E'.$row, $product_code);

				$objPHPExcel->getActiveSheet()->setCellValue('F'.$row, $product['price']);

				$objPHPExcel->getActiveSheet()->setCellValue('G'.$row, $product['quantity']);

				$objPHPExcel->getActiveSheet()->setCellValue('H'.$row, "=(F".$row.") * (G".$row.")");



				$objPHPExcel->getActiveSheet()->getStyle('B'.$row)->applyFromArray($stylebordersB);

				$objPHPExcel->getActiveSheet()->getStyle('D'.$row)->applyFromArray($styleborders);	

				$objPHPExcel->getActiveSheet()->getStyle('E'.$row)->applyFromArray($styleborders);	

				$objPHPExcel->getActiveSheet()->getStyle('F'.$row)->applyFromArray($styleborders);	

				$objPHPExcel->getActiveSheet()->getStyle('G'.$row)->applyFromArray($styleborders);	

				$objPHPExcel->getActiveSheet()->getStyle('H'.$row)->applyFromArray($stylebordersG);		

				if($row==19){

					$objPHPExcel->getActiveSheet()->getStyle('D'.$row)->applyFromArray($fillColorb);

					$objPHPExcel->getActiveSheet()->getRowDimension($row)->setRowHeight(40);

				}else{

					$objPHPExcel->getActiveSheet()->getStyle('D'.$row)->applyFromArray($fillColor);

					$objPHPExcel->getActiveSheet()->getRowDimension($row)->setRowHeight(14);

				}

				$objPHPExcel->getActiveSheet()->getStyle('G'.$row)->applyFromArray($fillColorToF);

				$objPHPExcel->getActiveSheet()->getStyle('D'.$row)->getAlignment()->setWrapText(true);

				$objPHPExcel->getActiveSheet()->getStyle('F'.$row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);

				$objPHPExcel->getActiveSheet()->getStyle('H'.$row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);

			}

			$objPHPExcel->getActiveSheet()->removeRow($baseRow-1,1);



			$netRow = ($baseRow-1) + count($products_list);

			$rowsum = $netRow-1;



			$objPHPExcel->getActiveSheet()->setCellValue('D'.($netRow + 1), 'Supports ISO 14644-3-B Air Flow Tests');



			$objPHPExcel->getActiveSheet()->setCellValue('B'.($netRow + 7), 'Ship');

			$objPHPExcel->getActiveSheet()->setCellValue('B'.($netRow + 8), 'From');

			$objPHPExcel->getActiveSheet()->setCellValue('B'.($netRow + 13), 'To');

			$objPHPExcel->getActiveSheet()->setCellValue('B'.($netRow + 14), 'eMail');



			$objPHPExcel->getActiveSheet()->setCellValue('B'.($netRow + 16), 'Authorized:');





			$objPHPExcel->getActiveSheet()->setCellValue('D'.($netRow + 7), 'Applied Physics, Inc.');

			$objPHPExcel->getActiveSheet()->setCellValue('D'.($netRow + 8), 'Accounting Department');

			$objPHPExcel->getActiveSheet()->setCellValue('D'.($netRow + 9), '2812 N 34th St.');

			$objPHPExcel->getActiveSheet()->setCellValue('D'.($netRow + 10), 'Tampa, Fl 33605 USA');

			$objPHPExcel->getActiveSheet()->setCellValue('D'.($netRow + 12), 'USA');

			$objPHPExcel->getActiveSheet()->setCellValue('D'.($netRow + 13), '719-428-4042');

			$objPHPExcel->getActiveSheet()->setCellValue('D'.($netRow + 14), 'Accounting@AppliedPhysicsUSA.com');

			$objPHPExcel->getActiveSheet()->getStyle('D'.($netRow + 14))->getAlignment()->setWrapText(true);



			$objPHPExcel->getActiveSheet()->setCellValue('F'.($netRow + 16), 'Cleanroom Fogger: ');

			$objPHPExcel->getActiveSheet()->setCellValue('F'.($netRow + 17), 'PSL and Silica Particles: ');

			$objPHPExcel->getActiveSheet()->setCellValue('F'.($netRow + 18), 'Wafer Calibration Standards: ');

			$objPHPExcel->getActiveSheet()->setCellValue('F'.($netRow + 19), 'NAICS Code: ');

			$objPHPExcel->getActiveSheet()->setCellValue('F'.($netRow + 20), 'DUNS #: ');

			$objPHPExcel->getActiveSheet()->setCellValue('F'.($netRow + 21), 'ECCN Code: ');



			$objPHPExcel->getActiveSheet()->setCellValue('H'.($netRow + 16), '8479.89.1000, Tariff Code');

			$objPHPExcel->getActiveSheet()->setCellValue('H'.($netRow + 17), '3822.00.0002, Tariff Code');

			$objPHPExcel->getActiveSheet()->setCellValue('H'.($netRow + 18), '9030.82.0000, Tariff Code');

			$objPHPExcel->getActiveSheet()->setCellValue('H'.($netRow + 19), '334516 ');

			$objPHPExcel->getActiveSheet()->setCellValue('H'.($netRow + 20), '55-753-5080');

			$objPHPExcel->getActiveSheet()->setCellValue('H'.($netRow + 21), 'EAR99');



			$objPHPExcel->getActiveSheet()->mergeCells('F'.($netRow + 16).':G'.($netRow + 16));

			$objPHPExcel->getActiveSheet()->mergeCells('F'.($netRow + 17).':G'.($netRow + 17));

			$objPHPExcel->getActiveSheet()->mergeCells('F'.($netRow + 18).':G'.($netRow + 18));

			$objPHPExcel->getActiveSheet()->mergeCells('F'.($netRow + 19).':G'.($netRow + 19));

			$objPHPExcel->getActiveSheet()->mergeCells('F'.($netRow + 20).':G'.($netRow + 20));

			$objPHPExcel->getActiveSheet()->mergeCells('F'.($netRow + 21).':G'.($netRow + 21));

					

			$objPHPExcel->getActiveSheet()->getStyle('F'.($netRow + 16).':G'.($netRow + 16))->applyFromArray($styleborders);	

			$objPHPExcel->getActiveSheet()->getStyle('F'.($netRow + 17).':G'.($netRow + 17))->applyFromArray($styleborders);	

			$objPHPExcel->getActiveSheet()->getStyle('F'.($netRow + 18).':G'.($netRow + 18))->applyFromArray($styleborders);	

			$objPHPExcel->getActiveSheet()->getStyle('F'.($netRow + 19).':G'.($netRow + 19))->applyFromArray($styleborders);

			$objPHPExcel->getActiveSheet()->getStyle('F'.($netRow + 20).':G'.($netRow + 20))->applyFromArray($styleborders);	

			$objPHPExcel->getActiveSheet()->getStyle('F'.($netRow + 21).':G'.($netRow + 21))->applyFromArray($styleborders);



			$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + 16))->applyFromArray($styleborders);	

			$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + 17))->applyFromArray($styleborders);	

			$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + 18))->applyFromArray($styleborders);	

			$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + 19))->applyFromArray($styleborders);	

			$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + 20))->applyFromArray($styleborders);

			$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + 21))->applyFromArray($styleborders);



			$objPHPExcel->getActiveSheet()->setCellValue('E'.($netRow + 7), 'Bank Wire Details');

			$objPHPExcel->getActiveSheet()->setCellValue('E'.($netRow + 8), 'JP Morgan Chase Bank');

			$objPHPExcel->getActiveSheet()->setCellValue('E'.($netRow + 9), 'SWIFT Code: CHASUS33XXX');

			$objPHPExcel->getActiveSheet()->setCellValue('E'.($netRow + 10), 'ABA Routing #: 102001017');

			$objPHPExcel->getActiveSheet()->setCellValue('E'.($netRow + 11), '1111 S. Hover Street');

			$objPHPExcel->getActiveSheet()->setCellValue('E'.($netRow + 12), 'Longmont, CO 80501 USA');

			$objPHPExcel->getActiveSheet()->setCellValue('E'.($netRow + 13), 'Tel: 1-303-651-1388');

			$objPHPExcel->getActiveSheet()->setCellValue('E'.($netRow + 14), 'Fax: 1-303-651-0153');



			$objPHPExcel->getActiveSheet()->setCellValue('D'.($netRow + 37), 'ÅP is a trademark of Applied Physics, Inc.  All rights reserved. Copyright since 1997.');

			$objPHPExcel->getActiveSheet()->setCellValue('D'.($netRow + 38), 'Bill To: 2812 N 34th St., Tampa, Fl 33605 USA. Ship To: 2812 N 34th St., Tampa, Fl 33605 USA.');



			$objPHPExcel->getActiveSheet()->getStyle('D'.($netRow + 37))->applyFromArray($styleArray);

			$objPHPExcel->getActiveSheet()->getStyle('D'.($netRow + 38))->applyFromArray($styleArray);



			$objPHPExcel->getActiveSheet()->setCellValue('H'.($netRow + 0), "=SUM(H18:H".$rowsum.")");

			$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + 0))->applyFromArray(array('alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT)));

			$objPHPExcel->getActiveSheet()->setCellValue('H'.($netRow + 2), "=SUM(H18:H".$rowsum.")");

			$objPHPExcel->getActiveSheet()->setCellValue('H'.($netRow + 3), "=SUM(H18:H".$rowsum.") + SUM(H18:H".$rowsum.")*5/100");
			
//			$objPHPExcel->getActiveSheet()->setCellValue('H'.($netRow + 4), "=SUM(H18:H".$rowsum.") + SUM(H18:H".$rowsum.")*2/100");


//			$objPHPExcel->getActiveSheet()->setCellValue('H'.($netRow + 5), "=SUM(H18:H".$rowsum.") + SUM(H18:H".$rowsum.")*4/100");

//			$objPHPExcel->getActiveSheet()->setCellValue('H'.($netRow + 6), "=SUM(H18:H".$rowsum.") + SUM(H18:H".$rowsum.")*6/100");

			$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + 2))->applyFromArray(array('alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT)));

			$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + 3))->applyFromArray(array('alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT)));

//			$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + 4))->applyFromArray(array('alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT)));

//			$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + 5))->applyFromArray(array('alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT)));

//			$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + 6))->applyFromArray(array('alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT)));

			$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + 0))->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);

			$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + 2))->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);

			$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + 3))->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);

//			$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + 4))->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);

//			$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + 5))->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);

//			$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + 6))->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);



			$objPHPExcel->getActiveSheet()->setCellValue('G'.($netRow + 1), '');

			$objPHPExcel->getActiveSheet()->setCellValue('F'.($netRow + 2), 'Wire with PO');

			$objPHPExcel->getActiveSheet()->setCellValue('F'.($netRow + 3), 'Credit Card +5%');

//			$objPHPExcel->getActiveSheet()->setCellValue('F'.($netRow + 4), 'Net 30 +2%');

//			$objPHPExcel->getActiveSheet()->setCellValue('F'.($netRow + 5), 'Net 60 +4%');

//			$objPHPExcel->getActiveSheet()->setCellValue('F'.($netRow + 6), 'Net 90 +6%');

			$objPHPExcel->getActiveSheet()->setCellValue('G'.($netRow + 2), '');



			$objPHPExcel->getActiveSheet()->setCellValue('G'.($netRow + 7), 'Furtherance To');

			$objPHPExcel->getActiveSheet()->setCellValue('G'.($netRow + 8), 'Applied Physics, Inc.');

			$objPHPExcel->getActiveSheet()->setCellValue('G'.($netRow + 9), '2812 N 34th St.');

			$objPHPExcel->getActiveSheet()->setCellValue('G'.($netRow + 10), 'Tampa, Fl 33605 USA');

			$objPHPExcel->getActiveSheet()->setCellValue('G'.($netRow + 11), 'James R. Ward');

			$objPHPExcel->getActiveSheet()->setCellValue('G'.($netRow + 12), 'Account #: 189710050');

			$objPHPExcel->getActiveSheet()->setCellValue('G'.($netRow + 13), 'Tel: 719-428-4042');

			$objPHPExcel->getActiveSheet()->setCellValue('G'.($netRow + 14), 'sales@appliedphysicsusa.com');



			$objPHPExcel->getActiveSheet()->mergeCells('B7:H7');

			$objPHPExcel->getActiveSheet()->mergeCells('D'.($netRow + 0).':E'.($netRow + 0));

			$objPHPExcel->getActiveSheet()->mergeCells('D'.($netRow + 1).':E'.($netRow + 1));



			$objPHPExcel->getActiveSheet()->mergeCells('G'.($netRow + 7).':H'.($netRow + 7));

			$objPHPExcel->getActiveSheet()->mergeCells('G'.($netRow + 8).':H'.($netRow + 8));

			$objPHPExcel->getActiveSheet()->mergeCells('G'.($netRow + 9).':H'.($netRow + 9));

			$objPHPExcel->getActiveSheet()->mergeCells('G'.($netRow + 10).':H'.($netRow + 10));

			$objPHPExcel->getActiveSheet()->mergeCells('G'.($netRow + 11).':H'.($netRow + 11));

			$objPHPExcel->getActiveSheet()->mergeCells('G'.($netRow + 12).':H'.($netRow + 12));

			$objPHPExcel->getActiveSheet()->mergeCells('G'.($netRow + 13).':H'.($netRow + 13));

			$objPHPExcel->getActiveSheet()->mergeCells('G'.($netRow + 14).':H'.($netRow + 14));

					

			$objPHPExcel->getActiveSheet()->mergeCells('E'.($netRow + 7).':F'.($netRow + 7));

			$objPHPExcel->getActiveSheet()->mergeCells('E'.($netRow + 8).':F'.($netRow + 8));

			$objPHPExcel->getActiveSheet()->mergeCells('E'.($netRow + 9).':F'.($netRow + 9));

			$objPHPExcel->getActiveSheet()->mergeCells('E'.($netRow + 10).':F'.($netRow + 10));

			$objPHPExcel->getActiveSheet()->mergeCells('E'.($netRow + 11).':F'.($netRow + 11));

			$objPHPExcel->getActiveSheet()->mergeCells('E'.($netRow + 12).':F'.($netRow + 12));

			$objPHPExcel->getActiveSheet()->mergeCells('E'.($netRow + 13).':F'.($netRow + 13));

			$objPHPExcel->getActiveSheet()->mergeCells('E'.($netRow + 14).':F'.($netRow + 14));

			$objPHPExcel->getActiveSheet()->mergeCells('D'.($netRow + 37).':H'.($netRow + 37));

			$objPHPExcel->getActiveSheet()->mergeCells('D'.($netRow + 38).':H'.($netRow + 38));

			// Protect cells

			$objPHPExcel->getActiveSheet()->getProtection()->setSheet(false);	// Needs to be set to true in order to enable any worksheet protection!

			$objPHPExcel->getActiveSheet()->protectCells('A3:F13', 'PHPExcel');



			// Set fonts

			$objPHPExcel->getActiveSheet()->getStyle('D2')->getFont()->setName('Times New Roman');

			$objPHPExcel->getActiveSheet()->getStyle('D2')->getFont()->setSize(15);

			$objPHPExcel->getActiveSheet()->getStyle('D2')->getFont()->setBold(true);

			$objPHPExcel->getActiveSheet()->getStyle('D2')->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_BLUE);

			$objPHPExcel->getActiveSheet()->getStyle('D2')->applyFromArray(array('alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT)));

					

			$objPHPExcel->getActiveSheet()->getStyle('G2')->getFont()->setName('Times New Roman');

			$objPHPExcel->getActiveSheet()->getStyle('G2')->getFont()->setSize(11);

			$objPHPExcel->getActiveSheet()->getStyle('G2')->getFont()->setBold(true);

			$objPHPExcel->getActiveSheet()->getStyle('G2')->getFont()->setUnderline(PHPExcel_Style_Font::UNDERLINE_SINGLE);

			$objPHPExcel->getActiveSheet()->getStyle('G2')->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_BLACK);



			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(0.2);

			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(6.5);

			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(5);

			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(51);

			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(17);

			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(19);

			$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(6);

			$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(55);

			$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(0.2);





			// Set thick brown border outline around "Total"

			$styleFill = array(

				'font'    => array(

					'bold'      => true

				),

				'fill' 	=> array(

					'type'		=> PHPExcel_Style_Fill::FILL_SOLID,

					'color'		=> array('rgb' => 'E2EFD9')

				),

				'alignment' => array(

					'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,

				),	

				'borders' => array(

					'bottom'	=> array('style' => PHPExcel_Style_Border::BORDER_THIN),

					'right'		=> array('style' => PHPExcel_Style_Border::BORDER_THIN),

					'left'	=> array('style' => PHPExcel_Style_Border::BORDER_THIN),

					'top'		=> array('style' => PHPExcel_Style_Border::BORDER_THIN)

				)					

			);



			$styleFill1 = array(

			'fill' 	=> array(

					'type'		=> PHPExcel_Style_Fill::FILL_SOLID,

					'color'		=> array('rgb' => 'E2EFD9')

				),

			'borders' => array(				

					'bottom'	=> array('style' => PHPExcel_Style_Border::BORDER_THIN),

					'right'		=> array('style' => PHPExcel_Style_Border::BORDER_THIN),

					'left'	=> array('style' => PHPExcel_Style_Border::BORDER_THIN),

					'top'		=> array('style' => PHPExcel_Style_Border::BORDER_THIN)

				)					

			);

			$fillcolorcurr2 = array('fill' 	=> array('type'		=> PHPExcel_Style_Fill::FILL_SOLID,'color'		=> array('rgb' => 'FFF3CB')));

			$fillcolorcurr3 = array('fill' 	=> array('type'		=> PHPExcel_Style_Fill::FILL_SOLID,'color'		=> array('rgb' => 'FFE799')));

			$fillcolorcurr4 = array('fill' 	=> array('type'		=> PHPExcel_Style_Fill::FILL_SOLID,'color'		=> array('rgb' => 'FFF3CB')));

			$fillcolorcurr5 = array('fill' 	=> array('type'		=> PHPExcel_Style_Fill::FILL_SOLID,'color'		=> array('rgb' => 'FFDB65')));

			$fillcolorcurr6 = array('fill' 	=> array('type'		=> PHPExcel_Style_Fill::FILL_SOLID,'color'		=> array('rgb' => 'C09300')));

			$objPHPExcel->getActiveSheet()->getStyle('F'.($netRow + 16).':H'.($netRow + 21))->applyFromArray($styleFill1);

			$objPHPExcel->getActiveSheet()->getStyle('F'.($netRow + 2).':H'.($netRow + 2))->applyFromArray($fillcolorcurr2);	

			$objPHPExcel->getActiveSheet()->getStyle('F'.($netRow + 3).':H'.($netRow + 3))->applyFromArray($fillcolorcurr3);

//			$objPHPExcel->getActiveSheet()->getStyle('F'.($netRow + 4).':H'.($netRow + 4))->applyFromArray($fillcolorcurr4);	

//			$objPHPExcel->getActiveSheet()->getStyle('F'.($netRow + 5).':H'.($netRow + 5))->applyFromArray($fillcolorcurr5);	

//			$objPHPExcel->getActiveSheet()->getStyle('F'.($netRow + 6).':H'.($netRow + 6))->applyFromArray($fillcolorcurr6);	



			$styleThickBrownBorderOutline = array(

				'font'    => array(

					'bold'      => true,

					'size'  => 10

				),

				'alignment' => array(

					'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,

				),

				'fill' 	=> array(

					'type'		=> PHPExcel_Style_Fill::FILL_SOLID,

					'color'		=> array('argb' => 'DFDFDFDF')

				),

				'borders' => array(

					'bottom'	=> array('style' => PHPExcel_Style_Border::BORDER_MEDIUM),

					'right'		=> array('style' => PHPExcel_Style_Border::BORDER_MEDIUM),

					'left'	=> array('style' => PHPExcel_Style_Border::BORDER_MEDIUM),

					'top'		=> array('style' => PHPExcel_Style_Border::BORDER_MEDIUM)

				)

			);

			$styleThickBrownBorderOutline1 = array(

				'font'    => array(

					'bold'  => true,

					'size'  => 10

				),

				'alignment' => array(

					'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,

				),

				'fill' 	=> array(

					'type' => PHPExcel_Style_Fill::FILL_SOLID,

					'color' => array('argb' => 'DFDFDFDF')

				),

				'borders' => array(

					'bottom'	=> array('style' => PHPExcel_Style_Border::BORDER_MEDIUM),

					'right'		=> array('style' => PHPExcel_Style_Border::BORDER_MEDIUM),

					'left'	=> array('style' => PHPExcel_Style_Border::BORDER_MEDIUM),

					'top'		=> array('style' => PHPExcel_Style_Border::BORDER_MEDIUM)

				)

			);	 

			$objPHPExcel->getActiveSheet()->getStyle('B8:H8')->applyFromArray($styleThickBrownBorderOutline1);

			$objPHPExcel->getActiveSheet()->getStyle('B17:H17')->applyFromArray($styleThickBrownBorderOutline);





			$objPHPExcel->getActiveSheet()->getStyle('B9:H9')->applyFromArray($styleborders);

			$objPHPExcel->getActiveSheet()->getStyle('B10:H10')->applyFromArray($styleborders);

			$objPHPExcel->getActiveSheet()->getStyle('B11:H11')->applyFromArray($styleborders);

			$objPHPExcel->getActiveSheet()->getStyle('B12:H12')->applyFromArray($styleborders);

			$objPHPExcel->getActiveSheet()->getStyle('B13:H13')->applyFromArray($styleborders);

			$objPHPExcel->getActiveSheet()->getStyle('B14:H14')->applyFromArray($styleborders);

			$objPHPExcel->getActiveSheet()->getStyle('B15:H15')->applyFromArray($styleborders);

			$objPHPExcel->getActiveSheet()->getStyle('B16:H16')->applyFromArray($styleborders);



			for($i=0;$i<=14;$i++){

				$objPHPExcel->getActiveSheet()->getStyle('B'.($netRow + $i))->applyFromArray($styleborders);

				$objPHPExcel->getActiveSheet()->getStyle('D'.($netRow + $i))->applyFromArray($styleborders);	

				$objPHPExcel->getActiveSheet()->getStyle('E'.($netRow + $i))->applyFromArray($styleborders);	

				$objPHPExcel->getActiveSheet()->getStyle('F'.($netRow + $i))->applyFromArray($styleborders);	

				$objPHPExcel->getActiveSheet()->getStyle('G'.($netRow + $i))->applyFromArray($styleborders);	

				$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + $i))->applyFromArray($styleborders);		

			}

			$styleFill2 = array(

				'fill' 	=> array(

					'type'		=> PHPExcel_Style_Fill::FILL_SOLID,

					'color'		=> array('rgb' => 'DFDFDFDF')

				),

				'borders' => array(

					'bottom'	=> array('style' => PHPExcel_Style_Border::BORDER_THIN),

					'right'		=> array('style' => PHPExcel_Style_Border::BORDER_THIN),

					'left'	=> array('style' => PHPExcel_Style_Border::BORDER_THIN),

					'top'		=> array('style' => PHPExcel_Style_Border::BORDER_THIN)

				)					

			);

			$styleFillhbr = array('borders' => array(	'right'	=> array('style' => PHPExcel_Style_Border::BORDER_MEDIUM)));

			$styleFillbbr = array('borders' => array(	'bottom'	=> array('style' => PHPExcel_Style_Border::BORDER_MEDIUM),'left'	=> array('style' => PHPExcel_Style_Border::BORDER_MEDIUM)));	 		 

				

			$objPHPExcel->getActiveSheet()->getStyle('E'.($netRow + 7).':H'.($netRow + 7))->applyFromArray($styleFill2);



			$objPHPExcel->getActiveSheet()->getStyle('H'.($netRow + 0).':H'.($netRow + 14))->applyFromArray($styleFillhbr);



			$topBaorder = array('borders' => array('top'=> array('style' => PHPExcel_Style_Border::BORDER_MEDIUM)));

			$bottomBaorder = array('borders' => array('bottom'=> array('style' => PHPExcel_Style_Border::BORDER_MEDIUM)));

			$rightBaorder = array('borders' => array('right'=> array('style' => PHPExcel_Style_Border::BORDER_MEDIUM)));

			$leftBaorder = array('borders' => array('left'=> array('style' => PHPExcel_Style_Border::BORDER_MEDIUM)));



			$objPHPExcel->getActiveSheet()->getStyle('B'.($netRow + 0).':H'.($netRow + 0))->applyFromArray($topBaorder);

			$objPHPExcel->getActiveSheet()->getStyle('B'.($netRow + 6).':H'.($netRow + 6))->applyFromArray($bottomBaorder);

			$objPHPExcel->getActiveSheet()->getStyle('B8:B'.($netRow + 14))->applyFromArray($leftBaorder);

			//$objPHPExcel->getActiveSheet()->getStyle('H8:H'.($netRow + 10))->applyFromArray($rightBaorder);

			$objPHPExcel->getActiveSheet()->getStyle('B'.($netRow + 14).':H'.($netRow + 14))->applyFromArray($bottomBaorder);





			// Add a drawing to the worksheet

			$objDrawing = new PHPExcel_Worksheet_Drawing();

			$objDrawing->setName('Logo');

			$objDrawing->setDescription('Logo');

			$objDrawing->setPath('images/Applied-Physics_transparent icon.png');

			$objDrawing->setCoordinates('B2');

			$objDrawing->setResizeProportional(false);

			$objDrawing->setWidth(57);

			//$objDrawing->setHeight(58);

			$objDrawing->setHeight(40);

			$objDrawing->setWorksheet($objPHPExcel->getActiveSheet());



			$objPHPExcel->getActiveSheet()->getStyle('D16')->getFont()->setName('Arial Narrow');

			$objPHPExcel->getActiveSheet()->getStyle('D16')->getFont()->setSize(9);

			$objPHPExcel->getActiveSheet()->getStyle('D16')->getFont()->setBold(true);

			$objPHPExcel->getActiveSheet()->getStyle('D16')->getFont()->setUnderline(PHPExcel_Style_Font::UNDERLINE_SINGLE);

			$objPHPExcel->getActiveSheet()->getStyle('D16')->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_BLUE);



			$objPHPExcel->getActiveSheet()->getStyle('H16')->getFont()->setName('Arial Narrow');

			$objPHPExcel->getActiveSheet()->getStyle('H16')->getFont()->setSize(9);

			$objPHPExcel->getActiveSheet()->getStyle('H16')->getFont()->setBold(true);

			$objPHPExcel->getActiveSheet()->getStyle('H16')->getFont()->setUnderline(PHPExcel_Style_Font::UNDERLINE_SINGLE);

			$objPHPExcel->getActiveSheet()->getStyle('H16')->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_BLUE);



			$objPHPExcel->getActiveSheet()->getStyle('D'.($netRow + 14))->getFont()->setName('Arial Narrow');

			$objPHPExcel->getActiveSheet()->getStyle('D'.($netRow + 14))->getFont()->setSize(9);

			$objPHPExcel->getActiveSheet()->getStyle('D'.($netRow + 14))->getFont()->setBold(true);

			$objPHPExcel->getActiveSheet()->getStyle('D'.($netRow + 14))->getFont()->setUnderline(PHPExcel_Style_Font::UNDERLINE_SINGLE);

			$objPHPExcel->getActiveSheet()->getStyle('D'.($netRow + 14))->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_BLUE);





			$objPHPExcel->getActiveSheet()->getStyle('G'.($netRow + 14))->getFont()->setName('Arial Narrow');

			$objPHPExcel->getActiveSheet()->getStyle('G'.($netRow + 14))->getFont()->setSize(9);

			$objPHPExcel->getActiveSheet()->getStyle('G'.($netRow + 14))->getFont()->setBold(true);

			$objPHPExcel->getActiveSheet()->getStyle('G'.($netRow + 14))->getFont()->setUnderline(PHPExcel_Style_Font::UNDERLINE_SINGLE);

			$objPHPExcel->getActiveSheet()->getStyle('G'.($netRow + 14))->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_BLUE);



			$objPHPExcel->getActiveSheet()->mergeCells('B'.($netRow + 16).':D'.($netRow + 16));

			$objPHPExcel->getActiveSheet()->mergeCells('B'.($netRow + 17).':D'.($netRow + 17));

			$objPHPExcel->getActiveSheet()->mergeCells('B'.($netRow + 18).':D'.($netRow + 18));

			//$objPHPExcel->getActiveSheet()->mergeCells('E'.($netRow + 2).':E'.($netRow + 6));



			$objDrawing = new PHPExcel_Worksheet_Drawing();

			$objDrawing->setName('Signature');

			$objDrawing->setDescription('Signature');

			$objDrawing->setPath('images/signature.png');

			$objDrawing->setCoordinates('D'.($netRow + 17));



			// set resize to false first

			$objDrawing->setResizeProportional(false);

			// set width later

			$objDrawing->setWidth(150);

			$objDrawing->setHeight(40);

			$objDrawing->setWorksheet($objPHPExcel->getActiveSheet());



			$objPHPExcel->getActiveSheet()->setCellValue('D'.($netRow + 20), 'Sales Manager');

				

			$objPHPExcel->getActiveSheet()->getStyle('B9:H9')->getAlignment()->setWrapText(true);

			$objPHPExcel->getActiveSheet()->getStyle('B10:H10')->getAlignment()->setWrapText(true);

			$objPHPExcel->getActiveSheet()->getStyle('B11:H11')->getAlignment()->setWrapText(true);

			$objPHPExcel->getActiveSheet()->getStyle('B12:H12')->getAlignment()->setWrapText(true);

			$objPHPExcel->getActiveSheet()->getStyle('B13:H13')->getAlignment()->setWrapText(true);

			$objPHPExcel->getActiveSheet()->getStyle('B9:B16')->applyFromArray($styleFill);

			$objPHPExcel->getActiveSheet()->getStyle('G9:G16')->applyFromArray($styleFill);	

			$objPHPExcel->getActiveSheet()->getStyle('D9:D16')->applyFromArray($styleborders);	

			$objPHPExcel->getActiveSheet()->getStyle('E9:E16')->applyFromArray($styleborders);	

			$objPHPExcel->getActiveSheet()->getStyle('F9:F16')->applyFromArray($styleborders);	

			$objPHPExcel->getActiveSheet()->getStyle('B'.($netRow + 7).':B'.($netRow + 14))->applyFromArray($styleFill);

			$objPHPExcel->getActiveSheet()->getStyle('B'.($netRow + 7).':B'.($netRow + 14))->applyFromArray($styleFillbbr);

			$objPHPExcel->getActiveSheet()->getStyle('F8')->applyFromArray(array('alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT)));

			$objPHPExcel->getActiveSheet()->getStyle('E9:E16')->applyFromArray(array('alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT)));

			$objPHPExcel->getActiveSheet()->getStyle('D'.($netRow + 20))->applyFromArray(array('font'    => array(

							'bold'      => true,

							'size'  => 12

						),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT)));

			$objPHPExcel->getActiveSheet()->getStyle('E'.($netRow + 22).':H'.($netRow + 22))->getAlignment()->setWrapText(true);

			$objPHPExcel->getActiveSheet()->setTitle('Quotes');	

			$objPHPExcel->getActiveSheet()->getStyle('F'.($netRow + 16).':F'.($netRow + 21))->applyFromArray(array('alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT)));

			$objPHPExcel->getActiveSheet()->getStyle('F'.($netRow + 16).':H'.($netRow + 18))->applyFromArray($fillColoryello);

			$objPHPExcel->getActiveSheet()->getPageMargins()->setTop(0.5);

			$objPHPExcel->getActiveSheet()->getPageMargins()->setRight(0.5);

			$objPHPExcel->getActiveSheet()->getPageMargins()->setLeft(0.5);

			$objPHPExcel->getActiveSheet()->getPageMargins()->setBottom(0.5);

			$objPHPExcel->getActiveSheet()->getPageMargins()->setHeader(0.5);

			$objPHPExcel->getActiveSheet()->getPageMargins()->setFooter(0.5);

		

		/* EXCEL***********************************/

		$file_name = $quote_data['quoteNumber'].'.xls';

		$xlsFilePath = 'upload/Quote #'.$deal_id.'.xls';

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');

		$objWriter->save($xlsFilePath);



		

		$arTests = array();

		$arTests['date'] = date('d.m.Y H:i:s');

		$arTests['REQUEST'] = $_REQUEST;

		

		

		//$crm_post_title = 'Export to Excel';

		$arMessage = 'The creation of Quote has been finished.';

		
	    if($deal_id && $deal_id !== ''){
			$msg_data = CRest::call("crm.timeline.comment.add", array(
	
				"fields" => array(
	
					"COMMENT" => $arMessage,
	
					"ENTITY_TYPE" => "deal",
	
					"ENTITY_ID"  => $deal_id,
	
					"FILES" => [
	
						[$file_name, base64_encode(file_get_contents($xlsFilePath))]
	
					],
	
				)
	
			));
	
			$arTests['crm.livefeedmessage.add'] = $msg_data;
		}





		/* from event_quote_create.php */

			sleep(2);

			
			if($contact_id && $contact_id !== ''){
				$address_contact = CRest::call("crm.address.list", array(
	
					"order" => [],
	
					"filter" => [
	
						"ENTITY_TYPE_ID" => 3,
	
						"ENTITY_ID" => $contact_id
	
					],
	
					'select' => ["ADDRESS_1", "ADDRESS_2", "CITY", "POSTAL_CODE", "REGION", "PROVINCE", "COUNTRY", "COUNTRY_CODE"]
	
				));
			}
			if(isset($address_contact) && $address_contact['result']){
				$address_contact_data = $address_contact['result'][0];
			}

			if(is_array($address_contact_data)){

				$contact_state = $address_contact_data['PROVINCE'];

				$contact_country = $address_contact_data['COUNTRY'];

			}

			sleep(1);

			$mailTitle = '';

			$mailText = '';

			$dtime = DateTime::createFromFormat("d/m/Y H:i:s", date("d/m/Y H:i:s"));

			$current_call_timestamp = $dtime->getTimestamp();

			$cur_time = date('c', $current_call_timestamp);

			

			$quote_create_date = date('m/d/Y H:i:s', strtotime($deal_data['DATE_CREATE']));

			$email_products_str = '';

			foreach($products_list as $k => &$product){

				$email_products_str .= "<br><a href='https://appliedphysics.bitrix24.com/crm/catalog/24/product/".$product['productId']."/' target='_blank'>".$product['productName']."</a>";

			}



			$arStaff_data = CRest::call("user.get", array(

				"ID" => $deal_data['ASSIGNED_BY_ID']

			));



			$mailTitle = "New Quote ".$quote_data['quoteNumber'];

			$mailText = "Attached is a New Quote For ".$contact_full_name." at ".$company_name." created at ".$quote_create_date."<br />

			<br />

			<br />

			<br />

			Contact Name:  <a href='https://appliedphysics.bitrix24.com/crm/contact/details/".$contact_id."/' target='_blank'>".$contact_full_name."</a> <br />

			Company: <a href='https://appliedphysics.bitrix24.com/crm/company/details/".$company_id."/' target='_blank'>".$company_name."</a> <br />

			Phone Number: ".$contact_phone." <br />

			State: ".$contact_state." <br />

			Country: ".$contact_country." <br />

			Email: ".$contact_email." <br />

			Products: ".$email_products_str ."<br />

			<br />

			<br />

			<br />

			Questions and Comments: ".$deal_data['COMMENTS']."<br />

			<br />

			<br />

			CRM Detail View URL - <a href='https://appliedphysics.bitrix24.com/crm/deal/details/".$deal_id."/' target='_blank'>".$deal_data['TITLE']."</a>

			<br />

			<br />

			<br />

			<br />";



			//	CRM Detail View URL- <a href='https://appliedphysics.bitrix24.com/crm/type/7/details/".$quote_id."/' target='_blank'>".$quote_data['title']."</a>

			

			$staff['ID'] = $arStaff_data['result'][0]['ID'];

			$staff['NAME'] = $arStaff_data['result'][0]['NAME'];

			$staff['LAST_NAME'] = $arStaff_data['result'][0]['LAST_NAME'];

			$staff['EMAIL'] = $arStaff_data['result'][0]['EMAIL'];

			

			$mail_comm_entity_id = $deal_id;

			$mail_comm_entity_type_id = 2;

			

			if($mail_comm_entity_id !== '' && $mail_comm_entity_type_id !== ''){

				$mail_fields = [

					"OWNER_TYPE_ID" => $mail_comm_entity_type_id,

					"OWNER_ID" => $mail_comm_entity_id,

					"TYPE_ID" => 4,

					"COMMUNICATIONS" => [

						[

							"VALUE" => 'sales@appliedphysicsusa.com',

							"ENTITY_ID" => 35546,

							"ENTITY_TYPE_ID" => 3

						]

					], 

					"SUBJECT" => $mailTitle,

					"START_TIME" => $cur_time,

					"END_TIME" => $cur_time,

					"COMPLETED" => "Y",  

					"RESPONSIBLE_ID" => $staff['ID'],

					"AUTHOR_ID" => $staff['ID'],

					"EDITOR_ID" => $staff['ID'],

					"DESCRIPTION" => $mailText,

					"DESCRIPTION_TYPE" => 3, //из метода crm.enum.contenttype - HTML

					"DIRECTION" => 2,

					'SETTINGS' => [

						'MESSAGE_FROM' => implode(

							' ',

							[$staff['NAME'], $staff['LAST_NAME'], '<' . $staff['EMAIL'] . '>']

						),

						'DISABLE_SENDING_MESSAGE_COPY' => 'Y'

					],

					"WEBDAV_ELEMENTS" => [

						'fileData' => [$file_name, base64_encode(file_get_contents($xlsFilePath))]

					]

				];

				sleep(5);

				$arDealMail_data = CRest::call("crm.activity.add", array(

					"fields" => $mail_fields

				));

				$arTests['mail_fields'] = $mail_fields;

				$arTests['arDealMail_data'] = $arDealMail_data;

				if($arQuoteMail_data['result']){

					if($quote_data['result']['item']['stageId'] == "DRAFT"){

						$arQuoteUpdate_data = CRest::call("crm.item.update", array(

							"entityTypeId" => 7,

							"id" => $quote_id,

							"fields" => ["stageId" => 'SENT']

						));

						$arTests['arQuoteUpdate_data'] = $arQuoteUpdate_data;

					}

				}

			}

		/* END from event_quote_create.php END */

		/*

		if($_REQUEST['event'] == "ONCRMQUOTEADD"){

			echo $file_name."*|*|*|*".$xlsFilePath;

		}elseif($msg_data['result']){

			*/

			echo 'Done! <br /> This window will close in 3 seconds...';

		/*

		}

		*/
	}else{

		echo "Error! <br /><br /> There are no products in this deal. <br /> Please, add them and try again. <br /><br /><br /> This window will close in 3 seconds...";

	}


	file_put_contents("deal export_quote.log", print_r($arTests, true), FILE_APPEND);

}

?>